﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using AZVIC.Ei8htPOS.POSRetail.Pages;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.BAL;
using System.Web.Security;
using AZVIC.Ei8htPOS.POSRetail.Constants;
using AZVIC.Ei8htPOS.POSRetail.Controls.Loading;
using AZVIC.Ei8htPOS.Utilities;

namespace AZVIC.Ei8htPOS.POSRetail.Controls
{
    /// <summary>
    /// Interaction logic for AddCustomerInfo.xaml
    /// </summary>
    public partial class AddCustomerInfo : Window
    {
        public AddCustomerInfo()
        {
            InitializeComponent();
            LoadCurrentOrderCustomer();
        }

        private void LoadCurrentOrderCustomer()
        {
            if (AppSession.CurrentUser != null)
            {
                txtFirstName.Text = AppSession.CurrentUser.FirstName;
                txtLastName.Text = AppSession.CurrentUser.LastName;
                txtEmail.Text = AppSession.CurrentUser.Email;
                txtPhone.Text = AppSession.CurrentUser.PhoneNo;
                txtMobile.Text = AppSession.CurrentUser.MobileNo;
                cbOccupation.SelectedItem = (ComboBoxItem)cbOccupation.FindName(AppSession.CurrentUser.CustomerType);
                txtAddress1.Text = AppSession.CurrentUser.Address1;
                txtAddress2.Text = AppSession.CurrentUser.Address2;
                txtCity.Text = AppSession.CurrentUser.City;
                txtState.Text = AppSession.CurrentUser.StateProvince;
                txtCountry.Text = AppSession.CurrentUser.Country;
                txtPostalCode.Text = AppSession.CurrentUser.PostalCode;
            }
        }

        /// <summary>
        /// Add Customer Event handler.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnAddCustomerInfo_Click(object sender, RoutedEventArgs e)
        {
            string ErrorText = string.Empty;
            if (ValidateEntry(out ErrorText))
            {
                if (AppSession.CurrentUser == null)
                {
                    AppSession.CurrentUser = new UserAccount();
                    AppSession.CurrentUser.Mode = Utilities.GlobalConfigurations.Mode.Insert;
                    AppSession.CurrentUser.UPassword = ValidationUtility.EncryptPassword(Membership.GeneratePassword(8, 0));
                }
                else
                    AppSession.CurrentUser.Mode = Utilities.GlobalConfigurations.Mode.Update;

                AppSession.CurrentUser.FirstName = txtFirstName.Text.Trim();
                AppSession.CurrentUser.LastName = txtLastName.Text.Trim();
                AppSession.CurrentUser.UserName = AppSession.CurrentUser.Email = txtEmail.Text.Trim();
                AppSession.CurrentUser.PhoneNo = txtPhone.Text.Trim();
                AppSession.CurrentUser.MobileNo = txtMobile.Text.Trim();
                AppSession.CurrentUser.UserRoleType = "User";
                AppSession.CurrentUser.CustomerType = cbOccupation.Text;

                AppSession.CurrentUser.Address1 = txtAddress1.Text.Trim();
                AppSession.CurrentUser.Address2 = txtAddress2.Text.Trim();
                AppSession.CurrentUser.City = txtCity.Text.Trim();
                AppSession.CurrentUser.StateProvince = txtState.Text.Trim();
                AppSession.CurrentUser.Country = txtCountry.Text.Trim();
                AppSession.CurrentUser.PostalCode = txtPostalCode.Text.Trim();

                if (txtEmail.Text.Trim().Length != 0)
                {
                    List<UserAccount> listUser = UserAccountBL.GetList(Guid.Empty, string.Empty, string.Empty, txtEmail.Text.Trim(), DateTime.MinValue, DateTime.MinValue);
                    if (listUser != null && listUser.Count > 0)
                    {
                        listUser = listUser.Where(a => a.IsActive).ToList<UserAccount>();
                    }
                    if (listUser.Count == 0 && AppSession.CurrentUser.Mode == Utilities.GlobalConfigurations.Mode.Insert)
                    {
                        if (UserAccountBL.Save(AppSession.CurrentUser))
                        {
                            if (AppSession.CurrentUser != null)
                            {
                                AppSession.SendWelcomeEmail(AppSession.CurrentUser);
                            }

                            AppSession.CurrentOrders.UsersAccountID = AppSession.CurrentUser.UniqueID;
                            AppSession.CurrentOrders.FirstName = AppSession.CurrentUser.FirstName;
                            AppSession.CurrentOrders.LastName = AppSession.CurrentUser.LastName;
                            AppSession.CurrentOrders.Email = AppSession.CurrentUser.Email;
                            AppSession.CurrentOrders.BillingAddress1 = AppSession.CurrentOrders.ShippingAddress1 = AppSession.CurrentUser.Address1;
                            AppSession.CurrentOrders.BillingAddress2 = AppSession.CurrentOrders.ShippingAddress2 = AppSession.CurrentUser.Address2;
                            AppSession.CurrentOrders.BillingCity = AppSession.CurrentOrders.ShippingCity = AppSession.CurrentUser.City;
                            AppSession.CurrentOrders.BillingState = AppSession.CurrentOrders.ShippingState = AppSession.CurrentUser.StateProvince;
                            AppSession.CurrentOrders.BillingCountry = AppSession.CurrentOrders.ShippingCountry = AppSession.CurrentUser.Country;
                            AppSession.CurrentOrders.BillingPostalCode = AppSession.CurrentOrders.ShippingPostalCode = AppSession.CurrentUser.PostalCode;
                            AppSession.CurrentOrders.BillingPhone = AppSession.CurrentOrders.ShippingPhone = AppSession.CurrentUser.PhoneNo;
                            AppSession.CurrentOrders.BillingMobile = AppSession.CurrentOrders.ShippingMobile = AppSession.CurrentUser.MobileNo;

                            this.Close();
                        }
                    }
                    else
                    {
                        if (AppSession.CurrentUser.Mode == Utilities.GlobalConfigurations.Mode.Insert)
                            MessageBox.Show("Customer already registered with Ei8ht POS", "Ei8htPOS", MessageBoxButton.OK, MessageBoxImage.Error, MessageBoxResult.OK);
                        else
                            this.Close();
                    }
                }
                else
                {
                    AppSession.CurrentOrders.FirstName = AppSession.CurrentUser.FirstName;
                    AppSession.CurrentOrders.LastName = AppSession.CurrentUser.LastName;
                    AppSession.CurrentOrders.Email = AppSession.CurrentUser.Email;
                    AppSession.CurrentOrders.BillingAddress1 = AppSession.CurrentOrders.ShippingAddress1 = AppSession.CurrentUser.Address1;
                    AppSession.CurrentOrders.BillingAddress2 = AppSession.CurrentOrders.ShippingAddress2 = AppSession.CurrentUser.Address2;
                    AppSession.CurrentOrders.BillingCity = AppSession.CurrentOrders.ShippingCity = AppSession.CurrentUser.City;
                    AppSession.CurrentOrders.BillingState = AppSession.CurrentOrders.ShippingState = AppSession.CurrentUser.StateProvince;
                    AppSession.CurrentOrders.BillingCountry = AppSession.CurrentOrders.ShippingCountry = AppSession.CurrentUser.Country;
                    AppSession.CurrentOrders.BillingPostalCode = AppSession.CurrentOrders.ShippingPostalCode = AppSession.CurrentUser.PostalCode;
                    AppSession.CurrentOrders.BillingPhone = AppSession.CurrentOrders.ShippingPhone = AppSession.CurrentUser.PhoneNo;
                    AppSession.CurrentOrders.BillingMobile = AppSession.CurrentOrders.ShippingMobile = AppSession.CurrentUser.MobileNo;

                    this.Close();
                }
            }
            else
            {
                MessageBox.Show(ErrorText, UIConstants.MANDATORY_FIELDS, MessageBoxButton.OK, MessageBoxImage.Error, MessageBoxResult.OK);
            }
        }

        /// <summary>
        /// Validate the User details entered.
        /// </summary>
        /// <param name="ErrorText"></param>
        /// <returns></returns>
        private bool ValidateEntry(out string ErrorText)
        {
            //TODO Add validations for newly added fields based on the business logic.
            string ErrRequiredFields = string.Empty, ErrFormatErrors = string.Empty;
            if (string.IsNullOrEmpty(txtFirstName.Text.Trim()))
                ErrRequiredFields += UIConstants.FIRST_NAME;
            if (string.IsNullOrEmpty(txtLastName.Text.Trim()))
                ErrRequiredFields = ErrRequiredFields.AddError(UIConstants.LAST_NAME);
            if (cbOccupation.SelectedIndex == -1)
                ErrRequiredFields = ErrRequiredFields.AddError(UIConstants.OCCUPATION);
            if (string.IsNullOrEmpty(txtEmail.Text.Trim()))
                ErrRequiredFields = ErrRequiredFields.AddError(UIConstants.EMAIL_ID);
            else
                ErrFormatErrors += ValidationUtility.ValidateEmail(txtEmail.Text.Trim()) ? string.Empty : UIConstants.EMAIL_FORMAT;

            if (!string.IsNullOrEmpty(txtPostalCode.Text) && !ValidationUtility.ValidateInt(txtPostalCode.Text.Trim()))
                ErrFormatErrors += UIConstants.POSTAL_CODE_FORMAT;

            if (!string.IsNullOrEmpty(txtMobile.Text) && !ValidationUtility.ValidatephoneNo(txtMobile.Text.Trim()))
                ErrFormatErrors += UIConstants.MOBILE_CODE_FORMAT;

            if (string.IsNullOrEmpty(txtPhone.Text.Trim()))
                ErrRequiredFields = ErrRequiredFields.AddError(UIConstants.PHONE_NUMBER);
            else
                ErrFormatErrors += ValidationUtility.ValidatephoneNo(txtPhone.Text.Trim()) ? string.Empty : UIConstants.PHONE_FORMAT;

            if (ErrRequiredFields.Empty() && ErrFormatErrors.Empty())
            {
                ErrorText = string.Empty;
                return true;
            }
            else
            {
                ErrorText = ErrRequiredFields.Empty() ? ErrFormatErrors : "Please enter " + ErrRequiredFields + "." + ErrFormatErrors;
                return false;
            }

        }

        private void btnSearch_Click(object sender, RoutedEventArgs e)
        {
            LoadSearch(txtSearchWord.Text.Trim(), txtStartDate.SelectedDate != null ? txtStartDate.SelectedDate.Value : DateTime.MinValue, txtEndDate.SelectedDate != null ? txtEndDate.SelectedDate.Value : DateTime.MinValue);
        }

        private void LoadSearch(string SearchString, DateTime startDate, DateTime endDate)
        {
            ProgressDialogResult result = ProgressDialog.Execute(Application.Current.MainWindow, string.Empty, (bw, we) =>
             {
                 List<UserAccount> pbList = UserAccountBL.GetList(Guid.Empty, string.Empty, string.Empty, SearchString, startDate, endDate);
                 pbList = pbList.Where(a => a.UserRoleType =="User" && a.IsActive).Select(a => a).ToList<UserAccount>();
                 gvCustomers.Dispatcher.BeginInvoke(new Action(() => gvCustomers.ItemsSource = pbList));
             });
        }

        private void btnSelectCustomer_Click(object sender, RoutedEventArgs e)
        {
            //Set the Current User Unique ID from sender.Tag value and store it in Some Appsession Variable and use it while checking out.
            Button btnSelectCustomer = sender as Button;
            Guid userAccountID = Guid.Parse(btnSelectCustomer.Tag.ToString());
            SelectCustomer(userAccountID);
            this.Close();
        }

        private void SelectCustomer(Guid userAccountID)
        {
            AppSession.CurrentUser = UserAccountBL.GetItem(userAccountID, string.Empty, string.Empty, string.Empty, DateTime.MinValue, DateTime.MinValue);
            AppSession.CurrentOrders.UsersAccountID = AppSession.CurrentUser.UniqueID;
            AppSession.CurrentOrders.FirstName = AppSession.CurrentUser.FirstName;
            AppSession.CurrentOrders.LastName = AppSession.CurrentUser.LastName;
            AppSession.CurrentOrders.Email = AppSession.CurrentUser.Email;
            AppSession.CurrentOrders.BillingAddress1 = AppSession.CurrentOrders.ShippingAddress1 = AppSession.CurrentUser.Address1;
            AppSession.CurrentOrders.BillingAddress2 = AppSession.CurrentOrders.ShippingAddress2 = AppSession.CurrentUser.Address2;
            AppSession.CurrentOrders.BillingCity = AppSession.CurrentOrders.ShippingCity = AppSession.CurrentUser.City;
            AppSession.CurrentOrders.BillingState = AppSession.CurrentOrders.ShippingState = AppSession.CurrentUser.StateProvince;
            AppSession.CurrentOrders.BillingCountry = AppSession.CurrentOrders.ShippingCountry = AppSession.CurrentUser.Country;
            AppSession.CurrentOrders.BillingPostalCode = AppSession.CurrentOrders.ShippingPostalCode = AppSession.CurrentUser.PostalCode;
            AppSession.CurrentOrders.BillingPhone = AppSession.CurrentOrders.ShippingPhone = AppSession.CurrentUser.PhoneNo;
            AppSession.CurrentOrders.BillingMobile = AppSession.CurrentOrders.ShippingMobile = AppSession.CurrentUser.MobileNo;
        }

        private void gvCustomers_MouseDoubleClick(object sender, MouseButtonEventArgs e)
        {
            UserAccount selectedUser;
            if (sender != null)
            {
                DataGrid grid = sender as DataGrid;
                if (gvCustomers != null && gvCustomers.SelectedItems != null && gvCustomers.SelectedItems.Count == 1)
                {
                    DataGridRow dgr = gvCustomers.ItemContainerGenerator.ContainerFromItem(gvCustomers.SelectedItem) as DataGridRow;
                    selectedUser = dgr.DataContext as UserAccount;
                    SelectCustomer(selectedUser.UniqueID);
                    this.Close();
                }

            }
        }

        private void txtSearchWord_TextChanged(object sender, TextChangedEventArgs e)
        {
            if (!string.IsNullOrEmpty(txtSearchWord.Text.Trim()))
                LoadSearch(txtSearchWord.Text.Trim(), txtStartDate.SelectedDate != null ? txtStartDate.SelectedDate.Value : DateTime.MinValue, txtEndDate.SelectedDate != null ? txtEndDate.SelectedDate.Value : DateTime.MinValue);
        }
        protected void btnCancel_Click(object sender, RoutedEventArgs e)
        {
            this.Close();
        }

    }
}
